/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class DarknessModifier
extends Modifier
implements ConditionalStatModifierHook {
    public static int getLight(Level world, BlockPos pos) {
        return Math.max(world.m_45517_(LightLayer.SKY, pos) - world.m_7445_(), world.m_45517_(LightLayer.BLOCK, pos));
    }

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, TinkerHooks.CONDITIONAL_STAT);
    }

    public void onBreakSpeed(@Nonnull IToolStackView tool, int level, @Nonnull PlayerEvent.BreakSpeed event, @Nonnull Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        BlockPos pos;
        Player player = event.getPlayer();
        Level world = player.m_20193_();
        int light = DarknessModifier.getLight(world, pos = event.getPos().m_7494_()) + 1;
        if (light < 10) {
            event.setNewSpeed((float)((double)event.getNewSpeed() * (1.0 + 0.5 * (double)level / (double)light)));
        }
    }

    public float getEntityDamage(@Nonnull IToolStackView tool, int level, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        BlockPos pos;
        Player player = context.getPlayerAttacker();
        Level world = player.m_20193_();
        int light = DarknessModifier.getLight(world, pos = player.m_20097_().m_7494_()) + 1;
        if (light < 10) {
            return (float)((double)damage * (1.0 + 0.5 * (double)level / (double)light));
        }
        return damage;
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        Level world = living.m_20193_();
        int level = modifier.getLevel();
        BlockPos pos = living.m_20097_().m_7494_();
        int light = DarknessModifier.getLight(world, pos) + 1;
        if (light < 10 && stat == ToolStats.DRAW_SPEED) {
            return (float)((double)baseValue * (1.0 + 0.5 * (double)level / (double)light));
        }
        return 0.0f;
    }

    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if (player != null && (harvest || tool.hasTag(TinkerTags.Items.RANGED)) && key == TooltipKey.SHIFT) {
            if (harvest) {
                this.addPercentTooltip((Component)new TranslatableComponent("modifier.tinkerscalibration.darkness.attack_damage"), 0.5 * (double)level, tooltip);
                this.addPercentTooltip((Component)new TranslatableComponent("modifier.tinkerscalibration.darkness.mining_speed"), 0.5 * (double)level, tooltip);
            } else {
                this.addPercentTooltip((Component)new TranslatableComponent("modifier.tinkerscalibration.darkness.draw_speed"), 0.5 * (double)level, tooltip);
            }
        }
    }
}

